import pygame
from pygame.locals import *
from constants import *

class Pacman(object):
    def __init__(self):
        self.position = pygame.Vector2(200, 400)
        self.direction = pygame.Vector2()
        self.speed = 100 * TILEWIDTH/16
        self.radius = 10
        self.color = YELLOW

    def updateDirection(self, direction):
        self.direction = direction

    def update(self, dt):	
        self.position += self.direction * self.speed * dt
    
    def render(self, screen):
        pygame.draw.circle(screen, self.color, self.position, self.radius)