import pygame
from pygame.locals import *
from constants import *

class Pacman(object):
    def __init__(self, node):
        self.setPosition(node)
        self.direction = pygame.Vector2()
        self.speed = 100 * TILEWIDTH/16
        self.radius = 10
        self.color = YELLOW
    
    def setPosition(self, node):
        self.node = node
        self.position = node.position.copy()
        self.validDirections = self.setValidDirections()


    def setValidDirections(self):
        '''Given that the player is on a Node, set the valid directions to this nodes neighbors'''
        validDirections = []
        for neighbor in self.node.neighbors:
            direction = neighbor.position - self.node.position
            validDirections.append(direction.normalize())
        return validDirections
    
    def checkValidDirection(self, direction):
        '''Check that the direction we want to go is in a valid direction'''
        if direction in self.validDirections: return True
        return False

    def updateDirection(self, direction):
        if self.checkValidDirection(direction):
            self.direction = direction
            self.setPosition(self.node.getNeighborByDirection(direction))

    def update(self, dt):	
        # self.position += self.direction * self.speed * dt
        pass
    
    def render(self, screen):
        pygame.draw.circle(screen, self.color, self.position, self.radius)