                          
import pygame
from constants import *

class Node(object):
    def __init__(self, x, y):
        self.position = pygame.Vector2(x, y)
        self.neighbors = []

    def addNeighbor(self, node):
        if node not in self.neighbors:  self.neighbors.append(node)

    def addNeighbors(self, nodelist):
        for node in nodelist:  self.addNeighbor(node)

    def getNeighborByDirection(self, direction):
        for neighbor in self.neighbors:
            test = (neighbor.position - self.position).normalize()
            if test == direction: return neighbor
        return None

    def render(self, screen):
        for node in self.neighbors:
            pygame.draw.line(screen, WHITE, self.position, node.position, 4)
            pygame.draw.circle(screen, RED, self.position, 12)
                        
                    

                          
class NodeGroup(object):
    def __init__(self):
        self.nodeList = []

    def setupTestNodes(self):
        nodeA = Node(80 ,80)
        nodeB = Node(160, 80)
        nodeC = Node(80, 160)
        nodeD = Node(160, 160)
        nodeE = Node(208, 160)
        nodeF = Node(80, 320)
        nodeG = Node(208, 320)

        nodeA.addNeighbors([nodeB, nodeC])
        nodeB.addNeighbors([nodeA, nodeD])
        nodeC.addNeighbors([nodeA, nodeD, nodeF])
        nodeD.addNeighbors([nodeB, nodeC, nodeE])
        nodeE.addNeighbors([nodeD, nodeG])
        nodeF.addNeighbors([nodeC, nodeG])
        nodeG.addNeighbors([nodeE, nodeF])

        self.nodeList = [nodeA, nodeB, nodeC, nodeD, nodeE, nodeF, nodeG]

    def render(self, screen):
        for node in self.nodeList:
            node.render(screen)
                        
                    